@extends('layouts.app')
@section('content')
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid">
			<div class="card border-0 shadow-custom">
				<div class="card-header border-grey">
					<h3 class="card-title">
						{{ __('user.title') }}
					</h3>
				</div>
				<form method="post" action="{{ route('user.store') }}" enctype="multipart/form-data">
                    {{ csrf_field() }}
					<div class="card-body">
						<div class="row">
							<div class="col-lg-12">
								<div class="user-image elevation-3 d-none" id="image-preview"></div>
							</div>
						</div>
						<div class="row">
							<div class="col-lg-12">
								<div class="form-group">
									<label for="name" class="required">{{ __('user.name') }}</label>
									<input type="text" value="{{ old('name') }}" class="form-control @error('name') is-invalid @enderror" name="name" id="name">
									@error('name')
										<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="email" class="required">{{ __('user.email') }}</label>
									<input type="text" value="{{ old('email') }}" class="form-control @error('email') is-invalid @enderror" name="email" id="email">
									@error('email')
										<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="password" class="required">{{ __('user.password') }}</label>
									<input type="password" value="{{ old('password') }}" class="form-control @error('password') is-invalid @enderror" name="password" id="password">
									@error('password')
										<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="js-user-role" class="required">{{ __('user.user_role') }}</label>						 
									<select class="form-control select-role @error('role') is-invalid @enderror" name="role" id="js-user-role">
										@foreach($roles as $role)
											<option value="{{ $role->id }}" {{ old('role') == $role->id ? 'selected' : '' }}>{{ $role->name }}</option>
										@endforeach
									</select>
									@error('role')
										<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="status">{{ __('user.status') }}</label> 
									<select class="form-control" name="status" id="status">
										<option value="active" {{ old('status') == 'active' ? 'selected' : '' }}>
											Active
										</option>
										<option value="disabled" {{ old('status') == 'disabled' ? 'selected' : '' }}>
											Disabled
										</option>
									</select>
								</div>
							</div>
							<div class="col-lg-12">
								<div class="form-group">
									<label for="profile_picture">{{ __('user.profile_picture') }}</label>
									<div class="input-group">
										<div class="custom-file">
											<input name="profile_picture" type="file" class="custom-file-input @error('profile_picture') is-invalid @enderror" id="profile_picture">
											<label class="custom-file-label" for="profile_picture">Choose file</label>
										</div>
									</div>
									@error('profile_picture')
										<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-12"> 
								<button type="submit" class="btn btn-primary mt-1">{{ __('user.save_user') }}</button>
							</div>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
@endsection
@section('js-script')
<!-- PAGE SPECIFIC CUSTOM SCRIPT -->
<script>
	$(function () {
		"use strict";
		// INITIALIZE SELECT2 ELEMENT
		$('.select-role').select2({
			theme: 'bootstrap4'
		})
		
		// EVENT LISTENER TO PREVIEW PROFILE IMAGE
		$('.custom-file-input').on('change', function() {
			if (this.files && this.files[0]) {
	
			var file = this.files[0];

			var reader = new FileReader();

			reader.onload = function(e) {
				$('#image-preview').css('background-image', 'url(' + e.target.result + ')');
				$('#image-preview').removeClass('d-none');
				$('#image-preview').addClass('mb-3');
			};

			reader.readAsDataURL(file);

			} else {
				$('#image-preview').addClass('d-none');
				$('#image-preview').removeClass('mb-3');
			}
		});
	});
</script>
@endsection